/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BooleanValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;

public class Arithmetic {
    public static final Value PI = new NumericValue(Math.PI);
    public static final Value euler = new NumericValue(Math.E);

    public static void apply(Expression expression) {
        expression.addTypedContextFunction("not", 1, Context.Type.BOOLEAN, (c, t, lv) -> BooleanValue.of(((Value)lv.get(0)).getBoolean()));
        expression.addUnaryFunction("fact", v -> {
            long number = NumericValue.asNumber(v).getLong();
            if (number < 21L) {
                long factorial = 1L;
                int i = 1;
                while ((long)i <= number) {
                    factorial *= (long)i;
                    ++i;
                }
                return new NumericValue(factorial);
            }
            if (number > 170L) {
                return NumericValue.of(Double.MAX_VALUE);
            }
            double factorial = 1.0;
            int i = 1;
            while ((long)i <= number) {
                factorial *= (double)i;
                ++i;
            }
            return new NumericValue(factorial);
        });
        expression.addMathematicalUnaryFunction("sin", d -> Math.sin(Math.toRadians(d)));
        expression.addMathematicalUnaryFunction("cos", d -> Math.cos(Math.toRadians(d)));
        expression.addMathematicalUnaryFunction("tan", d -> Math.tan(Math.toRadians(d)));
        expression.addMathematicalUnaryFunction("asin", d -> Math.toDegrees(Math.asin(d)));
        expression.addMathematicalUnaryFunction("acos", d -> Math.toDegrees(Math.acos(d)));
        expression.addMathematicalUnaryFunction("atan", d -> Math.toDegrees(Math.atan(d)));
        expression.addMathematicalBinaryFunction("atan2", (d, d2) -> Math.toDegrees(Math.atan2(d, d2)));
        expression.addMathematicalUnaryFunction("sinh", Math::sinh);
        expression.addMathematicalUnaryFunction("cosh", Math::cosh);
        expression.addMathematicalUnaryFunction("tanh", Math::tanh);
        expression.addMathematicalUnaryFunction("sec", d -> 1.0 / Math.cos(Math.toRadians(d)));
        expression.addMathematicalUnaryFunction("csc", d -> 1.0 / Math.sin(Math.toRadians(d)));
        expression.addMathematicalUnaryFunction("sech", d -> 1.0 / Math.cosh(d));
        expression.addMathematicalUnaryFunction("csch", d -> 1.0 / Math.sinh(d));
        expression.addMathematicalUnaryFunction("cot", d -> 1.0 / Math.tan(Math.toRadians(d)));
        expression.addMathematicalUnaryFunction("acot", d -> Math.toDegrees(Math.atan(1.0 / d)));
        expression.addMathematicalUnaryFunction("coth", d -> 1.0 / Math.tanh(d));
        expression.addMathematicalUnaryFunction("asinh", d -> Math.log(d + Math.sqrt(Math.pow(d, 2.0) + 1.0)));
        expression.addMathematicalUnaryFunction("acosh", d -> Math.log(d + Math.sqrt(Math.pow(d, 2.0) - 1.0)));
        expression.addMathematicalUnaryFunction("atanh", d -> {
            if (Math.abs(d) > 1.0 || Math.abs(d) == 1.0) {
                throw new InternalExpressionException("Number must be |x| < 1");
            }
            return 0.5 * Math.log((1.0 + d) / (1.0 - d));
        });
        expression.addMathematicalUnaryFunction("rad", Math::toRadians);
        expression.addMathematicalUnaryFunction("deg", Math::toDegrees);
        expression.addMathematicalUnaryFunction("ln", Math::log);
        expression.addMathematicalUnaryFunction("ln1p", Math::log1p);
        expression.addMathematicalUnaryFunction("log10", Math::log10);
        expression.addMathematicalUnaryFunction("log", a -> Math.log(a) / Math.log(2.0));
        expression.addMathematicalUnaryFunction("log1p", x -> Math.log1p(x) / Math.log(2.0));
        expression.addMathematicalUnaryFunction("sqrt", Math::sqrt);
        expression.addMathematicalUnaryFunction("abs", Math::abs);
        expression.addMathematicalUnaryIntFunction("round", Math::round);
        expression.addMathematicalUnaryIntFunction("floor", n -> (long)Math.floor(n));
        expression.addMathematicalUnaryIntFunction("ceil", n -> (long)Math.ceil(n));
        expression.addContextFunction("mandelbrot", 3, (c, t, lv) -> {
            long iter;
            double a0 = NumericValue.asNumber((Value)lv.get(0)).getDouble();
            double b0 = NumericValue.asNumber((Value)lv.get(1)).getDouble();
            long maxiter = NumericValue.asNumber((Value)lv.get(2)).getLong();
            double a = 0.0;
            double b = 0.0;
            for (iter = 0L; a * a + b * b < 4.0 && iter < maxiter; ++iter) {
                double temp = a * a - b * b + a0;
                b = 2.0 * a * b + b0;
                a = temp;
            }
            long iFinal = iter;
            return new NumericValue(iFinal);
        });
        expression.addFunction("max", lv -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'max' requires at least one parameter");
            }
            Value max = null;
            if (lv.size() == 1 && lv.get(0) instanceof ListValue) {
                lv = ((ListValue)lv.get(0)).getItems();
            }
            for (Value parameter : lv) {
                if (max != null && parameter.compareTo(max) <= 0) continue;
                max = parameter;
            }
            return max;
        });
        expression.addFunction("min", lv -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'min' requires at least one parameter");
            }
            Value min = null;
            if (lv.size() == 1 && lv.get(0) instanceof ListValue) {
                lv = ((ListValue)lv.get(0)).getItems();
            }
            for (Value parameter : lv) {
                if (min != null && parameter.compareTo(min) >= 0) continue;
                min = parameter;
            }
            return min;
        });
        expression.addUnaryFunction("relu", v -> v.compareTo(Value.ZERO) < 0 ? Value.ZERO : v);
    }
}

